ORCA/M Asm65816 2.1.0

0001 9210              **********************************************************************
0002 9210              *
0003 9210              * Event manager patch
0004 9210              *
0005 9210              * Copyright 1989-1992 Apple Computer, Inc.
0006 9210              * All Rights Reserved
0007 9210              *
0008 9210              **********************************************************************
0009 9210              *
0010 9210              * REVISION HISTORY
0011 9210              *
0012 9210              * 11/16/89          Mensch
0013 9210              *                   Added this patch file to insure that the event manager
0014 9210              *                   call table was in RAM. This is so the Dialog manager
0015 9210              *                   can patch it on the fly...
0016 9210              *                   Had to change a call so I made the version call patched.
0017 9210              *
0018 9210              * 23-Oct-90         Dave Lyons
0019 9210              *
0020 9210              * This file was not used before.  Changed version to $8301.
0021 9210              * Added GetNextEvent patch that checks to see if it was called by
0022 9210              * ModalDialog.  If so, we strip off app1-app4 events from the
0023 9210              * event mask.
0024 9210              *
0025 9210              * 11-Feb-91         Dave Lyons
0026 9210              *
0027 9210              * Added HandlePendingSysBeep2 routine for SysBeep2 requests that are
0028 9210              * deferred until the next GetNextEvent (this is useful for making a
0029 9210              * beep happen after a modal dialog is drawn).
0030 9210              *
0031 9210              * HandlePendinsSysBeep2 is exported to TS2.
0032 9210              *
0033 9210              * 25-Feb-91         Dave Lyons
0034 9210              *
0035 9210              * Patched EMStartUp and EMShutDown for preserving cursor position.
0036 9210              *
0037 9210              * 5-Mar-91          Dave Lyons
0038 9210              *
0039 9210              * Added a line in the GetNextEvent patch:  When it detects that the
0040 9210              * call is coming from ModalDialog, it now calls ModalDialogCursorPoll
0041 9210              * in Patch3:DialogMgr.pch.
0042 9210              *
0043 9210              * 9-Mar-91          Dave Lyons
0044 9210              *
0045 9210              * HandlePendingSysBeep2 now zeroes out the pending flag *before*
0046 9210              * calling SysBeep2, in case somebody calls GetNextEvent from within
0047 9210              * their SysBeep2 handler.
0048 9210              *
0049 9210              * 17-Sep-91         Dave Lyons
0050 9210              *
0051 9210              * Made PendingSysBeep2 a global so it can be shared between TS2/3
0052 9210              * and Tool.Setup (SysBeep2 is now in Tool.Setup, so I couldn't link).
0053 9210              *
0054 9210              * 5-Feb-92          Dave Lyons
0055 9210              *
0056 9210              * Version $0301 for 6.0 final.
0057 9210              *
0058 9210              **********************************************************************
0059 9210              *
0060 9210              * 3-Jun-92          Dave Lyons
0061 9210              *
0062 9210              * Version $8302 for 6.0.1d5 (changed UseCoolMousePos in em.asm).
0063 9210              *
0064 9210              * 2-Apr-93 DAL
0065 9210              *
0066 9210              * Version $0302 for 6.0.1
0067 9210              *
0068 9210              **********************************************************************
0069 9210              EMVerNum equ $0302 
0070 9210
0071 9210                       include 'all.macros' 
0072 9210
0073 9210              PendingSysBeep2 equ $E1167E 
0074 9210
0075 9210              ****************************************************************
0076 9210              *
0077 9210              * CALL TABLE
0078 9210              *
0079 9210              ****************************************************************
0080 9210              EMCallTable PROC Export 
0081 9210                       import EMVersion 
0082 9210                       import GetNextEvent 
0083 9210                       import EMStartUp               ;25-Feb-91 DAL
0084 9210                       import EMShutDown              ;25-Feb-91 DAL
0085 9210
0086 9210 1D 00 00 00           DC L:(TheEnd-EMCallTable)/4    ;num calls + 1
0087 9214 00 00 00 00           DC L:0                         ; EMBootInit-1
0088 9218 83 95 02 00           DC L:EMStartUp-1               ; 25-Feb-91 DAL
0089 921C AF 95 02 00           DC L:EMShutDown-1              ; 25-Feb-91 DAL
0090 9220 BC 95 02 00           DC L:EMVersion-1
0091 9224 00 00 00 00           DC L:0                         ; EMReset-1
0092 9228 00 00 00 00           DC L:0                         ; EMActive-1
0093 922C 00 00 00 00           DC L:0                         ; oEndCall0-1
0094 9230 00 00 00 00           DC L:0                         ; oEndCall0-1
0095 9234 00 00 00 00           DC L:0                         ; DoWindows-1
0096 9238 C6 95 02 00           DC L:GetNextEvent-1            ; 23-Oct-90 DAL
0097 923C 00 00 00 00           DC L:0                         ; EventAvail-1
0098 9240 00 00 00 00           DC L:0                         ; GetMouse-1
0099 9244 00 00 00 00           DC L:0                         ; Button-1
0100 9248 00 00 00 00           DC L:0                         ; StillDown-1
0101 924C 00 00 00 00           DC L:0                         ; WaitMouseUp-1
0102 9250 00 00 00 00           DC L:0                         ; TickCount-1
0103 9254 00 00 00 00           DC L:0                         ; GetDblTime-1
0104 9258 00 00 00 00           DC L:0                         ; GetCaretTime-1
0105 925C 00 00 00 00           DC L:0                         ; SetSwitch-1
0106 9260 00 00 00 00           DC L:0                         ; PostEvent-1
0107 9264 00 00 00 00           DC L:0                         ; FlushEvents-1
0108 9268 00 00 00 00           DC L:0                         ; GetOSEvent-1
0109 926C 00 00 00 00           DC L:0                         ; OSEventAvail-1
0110 9270 00 00 00 00           DC L:0                         ; SetEventMask-1
0111 9274 00 00 00 00           DC L:0                         ; FakeMouse-1         ; $1906
0112 9278 00 00 00 00           DC L:0                         ; SetAutoKeyLimit-1   ; $1A06
0113 927C 00 00 00 00           DC L:0                         ; GetKeyTranslation-1 ; $1B06
0114 9280 00 00 00 00           DC L:0                         ; SetKeyTranslation-1 ; $1C06
0115 9284              TheEnd    
0116 9284                       ENDP 
0117 9284
0118 9284              ****************************************************************
0119 9284              *
0120 9284              * EMStartUp -- patched 25-Feb-91 DAL
0121 9284              *
0122 9284              * Sets the cursor position based on message #6, if it exists
0123 9284              * and QuickDraw is active.
0124 9284              *
0125 9284              ****************************************************************
0126 9284              *
0127 9284              EMStartUp PROC 
0128 9284              *
0129 9284              * This routine calls the original EMStartup routine and then
0130 9284              * installs the keyboard interrupt handler
0131 9284              *
0132 9284              *
0133 9284              * Inputs:
0134 9284              *                   dPageAddr : word
0135 9284              *                   queueSize : word
0136 9284              *                   xMinClamp : word
0137 9284              *                   xMaxClamp : word
0138 9284              *                   yMinClamp : word
0139 9284              *                   yMaxClamp : word
0140 9284              *                   userID : word
0141 9284              *
0142 9284              * Outputs:
0143 9284              *                   none
0144 9284              *
0145 9284              ****************************************************************
0146 9284                       import UseCoolMousePos         ;24-Feb-91 DAL
0147 9284                       longa on 
0148 9284                       longi on 
0149 9284              ****************************************************************
0150 9284                       DefineStack 
0151 9284              RTL1     block 3 
0152 9284              RTL2     block 3 
0153 9284              origD    word 
0154 9284              UserID   word 
0155 9284              yMaxClamp word 
0156 9284              yMinClamp word 
0157 9284              xMaxClamp word 
0158 9284              xMinClamp word 
0159 9284              queueSize word 
0160 9284              dPageAddr word 
0161 9284
0162 9284
0163 9284              RealEMStartup equ   $FEE2A3             ;ROM 3 EMStartUp
0164 9284
0165 9284 AA                    tax                            ; save orig value of WAP in x
0166 9285 0B                    phd   
0167 9286 3B                    tsc   
0168 9287 5B                    tcd   
0169 9288
0170 9288 D4 15                 pei   dPageAddr                ; push all the params again
0171 928A D4 13                 pei   queueSize
0172 928C D4 11                 pei   xMinClamp
0173 928E D4 0F                 pei   xMaxClamp
0174 9290 D4 0D                 pei   yMinClamp
0175 9292 D4 0B                 pei   yMaxClamp
0176 9294 D4 09                 pei   UserID
0177 9296 8A                    txa                            ; get wap value back
0178 9297 22 AB 95 02           jsl   ToRealEMStartup          ; call the real startup code
0179 929B 48                    pha                            ; save any error code
0180 929C B0 04                 bcs   AnError
0181 929E
0182 929E              *** added 24-Feb-91 DAL
0183 929E 22 0A 96 02           jsl   UseCoolMousePos
0184 92A2              *** end of 24-Feb-91 DAL
0185 92A2
0186 92A2 FA           AnError  plx                            ; pull off the error code returned by orig startup call
0187 92A3 2B           AnError2 pld                            ; restore the direct page
0188 92A4 A0 0E 00              ldy   #14                      ; strip the inputs off the stack
0189 92A7 5C 84 01 E1           jml   $e10184                  ;ToStrip
0190 92AB
0191 92AB
0192 92AB 22 A3 E2 FE  ToRealEMstartup jsl   RealEMStartup
0193 92AF 6B                    rtl   
0194 92B0
0195 92B0                       ENDP 
0196 92B0
0197 92B0
0198 92B0              ****************************************************************
0199 92B0              *
0200 92B0              * EMShutDown -- patched 25-Feb-91 DAL
0201 92B0              *
0202 92B0              * Creates MessageCenter message #6 recording the old cursor
0203 92B0              * position.
0204 92B0              *
0205 92B0              ****************************************************************
0206 92B0              EMShutDown proc 
0207 92B0                       import CreateMouseMessage      ;24-Feb-91 DAL
0208 92B0
0209 92B0 AA                    tax   
0210 92B1 F0 06                 beq   @notStarted
0211 92B3 48                    pha                            ;save WAP for jumping to ROM
0212 92B4 22 9B 96 02           jsl   CreateMouseMessage
0213 92B8 68                    pla   
0214 92B9 5C B7 E4 FE  @notStarted jml   $fee4b7               ;original ROM 3 EMShutDown
0215 92BD
0216 92BD                       EndP 
0217 92BD
0218 92BD              ****************************************************************
0219 92BD              *
0220 92BD              * EMVersion
0221 92BD              *
0222 92BD              ****************************************************************
0223 92BD              EMVersion PROC Export 
0224 92BD A9 02 03              lda   #EMVerNum
0225 92C0 83 07                 sta   7,s
0226 92C2 A9 00 00              lda   #0
0227 92C5 18                    clc   
0228 92C6 6B                    RTL   
0229 92C7                       ENDP 
0230 92C7
0231 92C7              ****************************************************************
0232 92C7              *
0233 92C7              * GetNextEvent patch
0234 92C7              *
0235 92C7              * 23-Oct-90 DAL
0236 92C7              *
0237 92C7              * See if ModalDialog called us.  If so, mask off app1-app4
0238 92C7              * events.
0239 92C7              *
0240 92C7              ****************************************************************
0241 92C7              GetNextEvent PROC Export 
0242 92C7                       import HandlePendingSysBeep2 
0243 92C7                       import ModalDialogCursorPoll 
0244 92C7
0245 92C7 20 E9 95              jsr   HandlePendingSysBeep2
0246 92CA
0247 92CA 48                    pha   
0248 92CB
0249 92CB A3 06                 lda   4+2,s                    ;called from $fc7dd0?
0250 92CD C9 D3 7D              cmp   #$7dd0+3
0251 92D0 D0 12                 bne   @toROM
0252 92D2 A3 07                 lda   5+2,s
0253 92D4 C9 7D FC              cmp   #$fc7d
0254 92D7 D0 0B                 bne   @toROM
0255 92D9
0256 92D9 A3 0D                 lda   11+2,s
0257 92DB 29 FF 0F              and   #$0fff                   ;mask off app1-app4 events
0258 92DE 83 0D                 sta   11+2,s
0259 92E0
0260 92E0 22 F9 6B 02           jsl   ModalDialogCursorPoll    ;in Patch3:DialogMgr.pch (5-Mar-91 DAL)
0261 92E4
0262 92E4 68           @toROM   pla   
0263 92E5 5C CC E5 FE           jml   >$fee5cc
0264 92E9
0265 92E9                       EndP 
0266 92E9
0267 92E9              ****************************************************************
0268 92E9              *
0269 92E9              * HandlePendingSysBeep2
0270 92E9              *
0271 92E9              * 11-Feb-91 DAL
0272 92E9              *
0273 92E9              * If PendingSysBeep2 is nonzero, do the SysBeep2 call.
0274 92E9              *
0275 92E9              ****************************************************************
0276 92E9              HandlePendingSysBeep2 proc export  
0277 92E9 48                    pha   
0278 92EA 5A                    phy   
0279 92EB A3 11                 lda   11+6,s
0280 92ED 29 2A 00              and   #$002A                   ;keydown, autokey, mousedown?
0281 92F0 F0 15                 beq   @done                    ;nope, don't do the SysBeep2
0282 92F2 AF 7E 16 E1           lda   >PendingSysBeep2
0283 92F6 F0 0F                 beq   @done
0284 92F8 48                    pha   
0285 92F9 A9 00 00              lda   #0
0286 92FC 8F 7E 16 E1           sta   >PendingSysBeep2
0287 9300 A2 03 38 22           _SysBeep2 
0288 9307 7A           @done    ply   
0289 9308 68                    pla   
0290 9309 60                    rts   
0291 930A
0292 930A                       EndP 
0293 930A
0294 930A                       end   
